<?php
/*
	Metabox.php
	Meta Boxes For 20Script Posts
	Created by Dornaweb.ir - Am!n
	All rights Reserved
	20script theme designed by ivahid coded by dornaweb
*/

// Slider metabox
add_action( 'add_meta_boxes', 'meta_boxes_bistscript' );
function meta_boxes_bistscript() {
	add_meta_box('bist_metaboxes','گزینه های پست', 'bist_meta_location', 'post', 'advanced', 'high');
	

}
function bist_meta_location() {
	global $post;
	$download = get_post_meta($post->ID, '_download', $single = true);
	$mirror_download = get_post_meta($post->ID, '_mirror_download', $single = true);
	$demo = get_post_meta($post->ID, '_demo', $single = true);
	$vol = get_post_meta($post->ID, '_vol', $single = true);
	$creator = get_post_meta($post->ID, '_creator', $single = true);
	$translator = get_post_meta($post->ID, '_translator', $single = true);
	$source = get_post_meta($post->ID, '_source', $single = true);
	$source_link = get_post_meta($post->ID, '_source_link', $single = true);
	$help = get_post_meta($post->ID, '_help', $single = true);
	
	wp_nonce_field( 'dw_meta_box_nonce', 'meta_box_nonce' ); 
?>
<style>

.dornaweb_meta{
  width:100%;
}
.dornaweb_meta input,
.dornaweb_meta textarea{
  width:50%;
}
.dornaweb_meta label{
  width:120px;
  display:inline-block;
}
.dw_20_ltr{
  text-align:left;
  direction:ltr;
}

</style>

<div class="dornaweb_meta">

	<label for="download">لینک دانلود : </label> <input class="dw_20_ltr" id="download" type="text" name="_download" value="<?php echo $download; ?>">
	<br />
	<label for="mirror">دانلود غیر مستقیم : </label> <input class="dw_20_ltr" id="mirror" type="text" name="_mirror_download" value="<?php echo $mirror_download; ?>">
	<br />
	<label for="demo">دمو : </label> <input class="dw_20_ltr" id="demo" type="text" name="_demo" value="<?php echo $demo; ?>">
	<br />
	<label for="vol">حجم : </label> <input id="vol" type="text" name="_vol" value="<?php echo $vol; ?>">
	<br />
	<label for="creator">سازنده : </label> <input id="creator" type="text" name="_creator" value="<?php echo $creator; ?>">
	<br />
	<label for="translator">مترجم : </label> <input id="translator" type="text" name="_translator" value="<?php echo $translator; ?>">
	<br />
	<label for="source">منبع : </label> <input id="source" type="text" name="_source" value="<?php echo $source; ?>">
	<br />
	<label for="source_link">لینک منبع : </label> <input class="dw_20_ltr" id="source_link" type="text" name="_source_link" value="<?php echo $source_link; ?>">
	<br />
	<label for="help" style="margin-top:20px;">راهنمای نصب اسکریپت</label>
	<?php 
		$settings = array(
			'textarea_name' => '_help',
			'textarea_rows' => 5,
			'teeny' => true,
			'media_buttons' => false
		);
		wp_editor( $help,'help',$settings ); 
	?>

</div>
<?php
}

function save_slider_meta() {
	global $post;
	
	$metaboxes = array("_download","_mirror_download","_demo","_vol","_creator","_translator","_source","_source_link","_help");
	
	foreach ( $_POST as $key => $value ) {
		if( in_array( $key,$metaboxes ) ) {
			
			if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return; 
			 
			if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'dw_meta_box_nonce' ) ) return; 
			 
			if( !current_user_can( 'edit_post' ) ) return;
			
			if( isset($_POST[$key]) && $_POST[$key] != get_post_meta($post->ID, $value, true) ) {
				update_post_meta($post->ID, $key, $value);
			}
		}
	}
}

add_action('save_post', 'save_slider_meta');

?>